/*
 * Decompiled with CFR 0.152.
 */
package com.ferreusveritas.dynamictrees.systems.featuregen;

import com.ferreusveritas.dynamictrees.api.IPreGenFeature;
import com.ferreusveritas.dynamictrees.trees.Species;
import com.ferreusveritas.dynamictrees.util.SafeChunkBounds;
import com.ferreusveritas.dynamictrees.worldgen.JoCode;
import net.minecraft.block.state.IBlockState;
import net.minecraft.init.Blocks;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.World;

public class FeatureGenMudHole
implements IPreGenFeature {
    protected IBlockState mud;

    public FeatureGenMudHole(IBlockState mud) {
        this.mud = mud;
    }

    @Override
    public BlockPos preGeneration(World world, BlockPos rootPos, Species species, int radius, EnumFacing facing, SafeChunkBounds safeBounds, JoCode joCode) {
        int seaLevel = world.func_181545_F() - 1;
        IBlockState water = Blocks.field_150355_j.func_176223_P();
        if (rootPos.func_177956_o() == seaLevel) {
            for (int z = -2; z <= 2; ++z) {
                for (int x = -2; x <= 2; ++x) {
                    int sqrDist;
                    BlockPos offPos = rootPos.func_177971_a(new Vec3i(x, 0, z));
                    if (!safeBounds.inBounds(offPos, false) || !((float)(sqrDist = x * x + z * z) < 1.75f + world.field_73012_v.nextFloat())) continue;
                    world.func_175656_a(offPos.func_177979_c(2), this.mud);
                    world.func_175656_a(offPos.func_177979_c(1), this.mud);
                    if (!((float)sqrDist < 1.5f + world.field_73012_v.nextFloat())) continue;
                    world.func_175656_a(offPos, water);
                }
            }
        }
        return rootPos;
    }
}

